/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.math.methods.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.methods.MethodRegistry;

public class MultiFunctionMethods
extends MathMethod {
    private final int argCount;

    public MultiFunctionMethods(List<String> args, boolean isNegative, EMFAnimation calculationInstance, Function<List<Float>, Float> function) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        this.argCount = args.size();
        List<MathComponent> parsedArgs = MultiFunctionMethods.parseAllArgs(args, calculationInstance);
        this.setSupplierAndOptimize(() -> {
            ArrayList<Float> results = new ArrayList<Float>();
            for (MathComponent parsedArg : parsedArgs) {
                results.add(Float.valueOf(parsedArg.getResult()));
            }
            return ((Float)function.apply(results)).floatValue();
        }, parsedArgs);
    }

    public static MethodRegistry.MethodFactory makeFactory(String methodName, Function<List<Float>, Float> function) {
        return (args, isNegative, calculationInstance) -> {
            try {
                return new MultiFunctionMethods(args, isNegative, calculationInstance, function);
            }
            catch (Exception e) {
                throw new EMFMathException("Failed to create " + methodName + "() method, because: " + String.valueOf(e));
            }
        };
    }

    public static float quadraticBezier(float t, float p0, float p1, float p2) {
        float oneMinusT = 1.0f - t;
        return oneMinusT * oneMinusT * p0 + 2.0f * oneMinusT * t * p1 + t * t * p2;
    }

    public static float cubicBezier(float t, float p0, float p1, float p2, float p3) {
        float oneMinusT = 1.0f - t;
        float oneMinusTSquared = oneMinusT * oneMinusT;
        float tSquared = t * t;
        return oneMinusTSquared * oneMinusT * p0 + 3.0f * oneMinusTSquared * t * p1 + 3.0f * oneMinusT * tSquared * p2 + tSquared * t * p3;
    }

    public static float hermiteInterpolation(float t, float p0, float p1, float m0, float m1) {
        float tSquared = t * t;
        float tCubed = tSquared * t;
        float h00 = 2.0f * tCubed - 3.0f * tSquared + 1.0f;
        float h10 = tCubed - 2.0f * tSquared + t;
        float h01 = -2.0f * tCubed + 3.0f * tSquared;
        float h11 = tCubed - tSquared;
        return h00 * p0 + h10 * m0 + h01 * p1 + h11 * m1;
    }

    @Override
    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == this.argCount;
    }
}

